function swp2(A,filename)
% converts a matrix to a table in SWP4
% initially created by Vasco Curdia 03/11/03
%
% Table produced has numbers with 2 decimals
% Revised by Jean Boivin, Marc Giannoni and Ilian Mihov
%
% Input: a matrix variable already existing in the workspace
% output: (not visible in Matlab directly) This function creates a new file
%         called transfer.tex which is a file readable in both latex and
%         SWP4. This file is created in the current working directory.

[nr,nc]=size(A);
cc=repmat('c',1,nc);
fid=fopen(filename,'w');
fprintf(fid,'\n\\documentclass{article} \n');
fprintf(fid,'%%TCIDATA{OutputFilter=LATEX.DLL} \n');
fprintf(fid,'%%TCIDATA{Version=4.00.0.2321} \n');
fprintf(fid,'%%TCIDATA{Created=Tuesday, March 11, 2003 22:13:46} \n');
fprintf(fid,'%%TCIDATA{LastRevised=Tuesday, March 11, 2003 22:32:46} \n');
fprintf(fid,'%%TCIDATA{<META NAME="GraphicsSave" CONTENT="32">} \n');
fprintf(fid,'%%TCIDATA{<META NAME="DocumentShell" CONTENT="Standard LaTeX\\Blank - Standard LaTeX Article">} \n');
fprintf(fid,'%%TCIDATA{CSTFile=40 LaTeX article.cst} \n');
fprintf(fid,'\\input{tcilatex} \n');
fprintf(fid,'\\begin{document} \n');
fprintf(fid,'\\begin{tabular}{%s} \n',cc);
for i=1:nr
    text=sprintf('%0.4f',A(i,1));
    for j=2:nc
        text=[text ' & ' sprintf('%0.4f',A(i,j))];
    end
    if i==nr
        text=[text ' \n'];
    else
        text=[text ' \\\\ \n'];
    end
    fprintf(fid,text);
end
fprintf(fid,'\\end{tabular} \n');
fprintf(fid,'\\end{document} \n');
fclose(fid);

